<?php
// Copyright (C) 2016 Combodo SARL
//
//   This program is free software; you can redistribute it and/or modify
//   it under the terms of the GNU Lesser General Public License as published by
//   the Free Software Foundation; version 3 of the License.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//   GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program; if not, write to the Free Software
//   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
/**
 * @copyright   Copyright (C) 2016 Combodo SARL
 * @license     http://opensource.org/licenses/AGPL-3.0
 */

/**
 * Declare the static properties for use in MailInboxBase which cannot be declared in XML
 */
abstract class _MailInboxBase extends cmdbAbstractObject
{
	protected static $iMinImageWidth = null;
	protected static $iMaxImageWidth = null;
	protected static $iMinImageHeight = null;
	protected static $iMaxImageHeight = null;
	protected static $aExcludeAttachments = null;

	/**
	 * @var int
	 * Property is public as it is used by outside scripts. The declaration was just made to make it compatible with PHP 8.2, for a better fix we might want to make a proper getter / setter.
	 */
	public $iMaxAttachmentSize;
	/**
	 * @var string
	 * Property is public as it is used by outside scripts. The declaration was just made to make it compatible with PHP 8.2, for a better fix we might want to make a proper getter / setter.
	 */
	public $sBigFilesDir;
	/**
	 * @var string
	 * Property is public as it is used by outside scripts. The declaration was just made to make it compatible with PHP 8.2, for a better fix we might want to make a proper getter / setter.
	 */
	public $sLastError;

	const XML_LEGACY_VERSION = '1.7';

	/**
	 * Compare static::XML_LEGACY_VERSION with ITOP_DESIGN_LATEST_VERSION and returns true if the later is <= to the former.
	 * If static::XML_LEGACY_VERSION, return false
	 *
	 * @return bool
	 *
	 * @since 3.4.0
	 */
	public static function UseLegacy(){
		return static::XML_LEGACY_VERSION !== '' ? version_compare(ITOP_DESIGN_LATEST_VERSION, static::XML_LEGACY_VERSION, '<=') : false;
	}
}